<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/layout.php';
require_company();

$companyId = (int)$_SESSION['company_id'];
$msg = null; $err = null;

function random_token(): string {
  return sha1(bin2hex(random_bytes(32)) . microtime(true));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pickup_address  = trim((string)($_POST['pickup_address'] ?? ''));
  $dropoff_address = trim((string)($_POST['dropoff_address'] ?? ''));
  $customer_name   = trim((string)($_POST['customer_name'] ?? ''));
  $customer_phone  = trim((string)($_POST['customer_phone'] ?? ''));

  $pickup_lat  = (string)($_POST['pickup_lat'] ?? '');
  $pickup_lng  = (string)($_POST['pickup_lng'] ?? '');
  $dropoff_lat = (string)($_POST['dropoff_lat'] ?? '');
  $dropoff_lng = (string)($_POST['dropoff_lng'] ?? '');

  if ($pickup_address === '' || $dropoff_address === '') {
    $err = "Informe endereço de coleta e entrega.";
  } elseif ($pickup_lat === '' || $pickup_lng === '' || $dropoff_lat === '' || $dropoff_lng === '') {
    $err = "Clique no mapa para marcar coleta e entrega.";
  } else {
    $token = random_token();

    $st = $pdo->prepare("
      INSERT INTO deliveries
      (company_id, pickup_address, pickup_lat, pickup_lng, dropoff_address, dropoff_lat, dropoff_lng, customer_name, customer_phone, tracking_token)
      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    $st->execute([
      $companyId,
      $pickup_address,
      $pickup_lat,
      $pickup_lng,
      $dropoff_address,
      $dropoff_lat,
      $dropoff_lng,
      ($customer_name !== '' ? $customer_name : null),
      ($customer_phone !== '' ? $customer_phone : null),
      $token
    ]);

    $id = (int)$pdo->lastInsertId();
    $msg = "Entrega criada! Link de rastreio: track.php?t=$token (ID #$id)";
  }
}

render_header('Empresa - Nova entrega');
?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css">
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<div class="card">
  <h1>Solicitar motoboy</h1>
  <p class="small">
    Preencha os endereços e <b>marque no mapa</b> (1º clique = coleta, 2º clique = entrega).
    Isso alimenta a fila inteligente automaticamente.
  </p>

  <?php if ($msg): ?><div class="notice"><?= h($msg) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="notice"><?= h($err) ?></div><?php endif; ?>

  <form method="post" class="grid">
    <div class="grid grid-2">
      <div>
        <label>Endereço de coleta</label>
        <input name="pickup_address" required placeholder="Rua X, 123">
      </div>

      <div>
        <label>Endereço de entrega</label>
        <input name="dropoff_address" required placeholder="Av Y, 456">
      </div>
    </div>

    <div>
      <label>Mapa (clique para marcar)</label>
      <div id="map" style="height:380px; border-radius:14px; border:1px solid rgba(255,255,255,.08);"></div>
      <div class="small" id="mapHint" style="margin-top:8px;">Clique 1: Coleta. Clique 2: Entrega.</div>
    </div>

    <input type="hidden" name="pickup_lat" id="pickup_lat">
    <input type="hidden" name="pickup_lng" id="pickup_lng">
    <input type="hidden" name="dropoff_lat" id="dropoff_lat">
    <input type="hidden" name="dropoff_lng" id="dropoff_lng">

    <div class="grid grid-2">
      <div>
        <label>Nome do cliente (opcional)</label>
        <input name="customer_name">
      </div>
      <div>
        <label>Telefone do cliente (opcional)</label>
        <input name="customer_phone">
      </div>
    </div>

    <div style="display:flex; gap:10px; flex-wrap:wrap;">
      <button class="btn btn-primary" type="submit">Criar solicitação</button>
      <a class="btn" href="company_dashboard.php">Voltar</a>
      <a class="btn" href="company_deliveries.php">Ver entregas</a>
      <button class="btn btn-ghost" type="button" id="myLoc">Centralizar na minha localização</button>
      <button class="btn btn-ghost" type="button" id="resetMarks">Limpar marcações</button>
    </div>
  </form>
</div>

<script>
let map = L.map('map').setView([-3.7319, -38.5267], 12); // default (Fortaleza)
L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19 }).addTo(map);

let pickupMarker = null;
let dropoffMarker = null;

function setHidden(id, val){ document.getElementById(id).value = val; }

map.on('click', (e) => {
  const {lat, lng} = e.latlng;

  if(!pickupMarker){
    pickupMarker = L.marker([lat,lng]).addTo(map).bindPopup('Coleta').openPopup();
    setHidden('pickup_lat', lat);
    setHidden('pickup_lng', lng);
    document.getElementById('mapHint').textContent = 'Agora clique no ponto de ENTREGA.';
    return;
  }
  if(!dropoffMarker){
    dropoffMarker = L.marker([lat,lng]).addTo(map).bindPopup('Entrega').openPopup();
    setHidden('dropoff_lat', lat);
    setHidden('dropoff_lng', lng);
    document.getElementById('mapHint').textContent = 'Pronto! Você marcou coleta e entrega.';
    return;
  }
  // se clicar de novo, atualiza entrega
  dropoffMarker.setLatLng([lat,lng]).openPopup();
  setHidden('dropoff_lat', lat);
  setHidden('dropoff_lng', lng);
});

document.getElementById('resetMarks').addEventListener('click', () => {
  if(pickupMarker){ map.removeLayer(pickupMarker); pickupMarker = null; }
  if(dropoffMarker){ map.removeLayer(dropoffMarker); dropoffMarker = null; }
  setHidden('pickup_lat',''); setHidden('pickup_lng','');
  setHidden('dropoff_lat',''); setHidden('dropoff_lng','');
  document.getElementById('mapHint').textContent = 'Clique 1: Coleta. Clique 2: Entrega.';
});

document.getElementById('myLoc').addEventListener('click', () => {
  if(!navigator.geolocation) return alert('Sem geolocalização.');
  navigator.geolocation.getCurrentPosition((pos)=>{
    map.setView([pos.coords.latitude, pos.coords.longitude], 16);
  }, (err)=> alert('Erro GPS: '+err.message), { enableHighAccuracy:true, timeout:8000 });
});
</script>

<?php render_footer(); ?>
