<?php
declare(strict_types=1);
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';
require_motoboy();

header('Content-Type: application/json');

$motoboyId = (int)$_SESSION['motoboy_id'];
$lat = (float)($_POST['lat'] ?? 0);
$lng = (float)($_POST['lng'] ?? 0);

if (abs($lat) < 0.00001 || abs($lng) < 0.00001) {
  echo json_encode(['ok'=>false,'error'=>'Localização inválida']); exit;
}

$st = $pdo->prepare("UPDATE motoboys SET last_lat=?, last_lng=?, last_seen=NOW() WHERE id=?");
$st->execute([$lat, $lng, $motoboyId]);

echo json_encode(['ok'=>true]);
