<?php
declare(strict_types=1);
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';
require_motoboy();

header('Content-Type: application/json');

$motoboyId = (int)$_SESSION['motoboy_id'];
$deliveryId = (int)($_POST['delivery_id'] ?? 0);
$lat = (float)($_POST['lat'] ?? 0);
$lng = (float)($_POST['lng'] ?? 0);

if ($deliveryId <= 0 || abs($lat) < 0.00001 || abs($lng) < 0.00001) {
  echo json_encode(['ok'=>false,'error'=>'Localização inválida']); exit;
}

$st = $pdo->prepare("SELECT id FROM deliveries WHERE id=? AND motoboy_id=?");
$st->execute([$deliveryId, $motoboyId]);
if (!$st->fetch()) {
  echo json_encode(['ok'=>false,'error'=>'Entrega não pertence a você']); exit;
}

$st = $pdo->prepare("INSERT INTO delivery_locations (delivery_id, motoboy_id, lat, lng) VALUES (?,?,?,?)");
$st->execute([$deliveryId, $motoboyId, $lat, $lng]);

$st = $pdo->prepare("UPDATE motoboys SET last_lat=?, last_lng=?, last_seen=NOW() WHERE id=?");
$st->execute([$lat, $lng, $motoboyId]);

echo json_encode(['ok'=>true]);
