<?php
declare(strict_types=1);
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';
require_motoboy();

header('Content-Type: application/json');

$motoboyId = (int)$_SESSION['motoboy_id'];
$deliveryId = (int)($_POST['delivery_id'] ?? 0);

if ($deliveryId <= 0) {
  echo json_encode(['ok'=>false,'error'=>'ID inválido']); exit;
}

$pdo->beginTransaction();
try {
  $st = $pdo->prepare("SELECT status FROM deliveries WHERE id=? FOR UPDATE");
  $st->execute([$deliveryId]);
  $d = $st->fetch();

  if (!$d) throw new RuntimeException('Entrega não existe.');
  if ($d['status'] !== 'waiting') throw new RuntimeException('Entrega não está disponível.');

  $st = $pdo->prepare("
    UPDATE deliveries
    SET motoboy_id=?, status='accepted', accepted_at=NOW()
    WHERE id=? AND status='waiting'
  ");
  $st->execute([$motoboyId, $deliveryId]);

  $pdo->commit();
  echo json_encode(['ok'=>true]);
} catch (Throwable $e) {
  $pdo->rollBack();
  echo json_encode(['ok'=>false,'error'=>$e->getMessage()]);
}
