# APP ENTREGADOR (PHP + MySQL) - MVP com Leaflet + SSE

Este pacote inclui:
- Painel Empresa: login, criar entrega, acompanhar em tempo real (SSE), mapa (Leaflet), link do cliente, ver foto, avaliar 1-5
- Painel Motoboy: login, online/offline, atualizar posição, fila inteligente por raio/distância, aceitar entrega, status, enviar localização, upload de foto
- Rastreio público do cliente: mapa em tempo real (SSE) + rota (polilinha)

## Requisitos
- PHP 8+
- MySQL 5.7+ / MariaDB 10+
- HTTPS no domínio/subdomínio (recomendado/necessário para GPS em celulares)

## Instalação no cPanel (Apache)
1) Envie a pasta `app/` para dentro do seu `public_html/` (exemplo: `public_html/app/`).
   - Ou envie como `public_html/` direto, se preferir.

2) Crie o banco e usuário no cPanel:
   - MySQL® Databases → crie DB, usuário e dê ALL PRIVILEGES no DB.

3) Importe o schema:
   - phpMyAdmin → selecione o DB → Import → `SQL/01_create_schema.sql`
   - (Opcional) Import → `SQL/02_seed_demo.sql`
     OU (recomendado) rode `app/seed.php` no navegador 1 vez e depois apague.

4) Configure o banco em `app/db.php`:
   - $DB_HOST, $DB_NAME, $DB_USER, $DB_PASS

5) Permissões de upload:
   - Garanta que `app/uploads/` e `app/uploads/proofs/` sejam graváveis.
   - Em geral 755 funciona; se não, ajuste conforme seu host.

6) Acesse:
   - https://seu-dominio.com/app/index.php

## Usuários demo
- Empresa: empresa@teste.com / 123456
- Motoboy: moto@teste.com / 123456

## Como usar
1) Empresa cria entrega (coloque pickup_lat/lng para a fila inteligente por distância funcionar).
2) Motoboy fica online, atualiza posição (GPS) e aceita a entrega.
3) Motoboy envia localização a cada 5s e depois envia foto.
4) Cliente acompanha via link `track.php?t=TOKEN`.
5) Quando status = delivered, empresa pode avaliar 1-5.

## Configurações úteis
- Raio de busca (km): `app/motoboy_deliveries.php` variável `$radiusKm = 8;`

## Segurança (mínimo)
- Remova `app/seed.php` após usar.
- Considere criar um .htaccess no app/ para impedir listagem de diretórios (já existe para uploads).
- Ideal: validar CSRF e rate-limit em produção (próxima etapa).

## Próximos upgrades (se quiser)
- Criar entrega escolhendo pontos no mapa (click → preenche lat/lng)
- Push notifications / Web Push
- Painel Admin
- WebSocket (se migrar para VPS ou usar serviço)


## Alterações (03/2026)
- Formulário da empresa agora marca coleta/entrega pelo MAPA (Leaflet) e salva lat/lng automaticamente.
- Fila inteligente do motoboy NÃO esconde mais entregas sem coordenadas (aparecem por último, sem distância).
- Mapas de acompanhamento iniciam centralizados na coleta quando disponível.
