<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/layout.php';
require_motoboy();

$motoboyId = (int)$_SESSION['motoboy_id'];

$st = $pdo->prepare("SELECT is_online FROM motoboys WHERE id = ?");
$st->execute([$motoboyId]);
$isOnline = (int)($st->fetch()['is_online'] ?? 0);

render_header('Motoboy - Dashboard');
?>
<div class="grid grid-2">
  <div class="card">
    <h1>Olá, <?= h((string)$_SESSION['motoboy_name']) ?></h1>
    <div class="row" style="align-items:center;">
      <div>
        Status:
        <?php if ($isOnline): ?>
          <span class="badge ok">ONLINE</span>
        <?php else: ?>
          <span class="badge danger">OFFLINE</span>
        <?php endif; ?>
      </div>
      <div style="text-align:right;">
        <button class="btn <?= $isOnline ? 'btn-danger' : 'btn-ok' ?>" id="toggleBtn">
          <?= $isOnline ? 'Ficar offline' : 'Ficar online' ?>
        </button>
      </div>
    </div>

    <div style="margin-top:10px; display:flex; gap:10px; flex-wrap:wrap;">
      <button class="btn btn-primary" id="posBtn">Atualizar minha posição</button>
      <a class="btn" href="motoboy_deliveries.php">Ver entregas</a>
    </div>
    <div class="small" id="posMsg" style="margin-top:6px;"></div>

    <p class="small" style="margin-top:10px;">
      A <b>fila inteligente</b> usa sua última posição para mostrar entregas por distância.
    </p>
  </div>

  <div class="card">
    <h1>Como funciona</h1>
    <ul class="small" style="line-height:1.6">
      <li>Fique online.</li>
      <li>Atualize sua posição (GPS).</li>
      <li>Aceite uma entrega disponível.</li>
      <li>Atualize status: accepted → picked_up → delivering → delivered.</li>
      <li>Envie localização a cada 5s (durante a entrega).</li>
      <li>Envie a foto como prova.</li>
    </ul>
  </div>
</div>

<script>
document.getElementById('toggleBtn').addEventListener('click', async () => {
  const res = await fetch('api/toggle_online.php', { method:'POST' });
  const j = await res.json();
  if (j.ok) location.reload();
  else alert(j.error || 'Erro');
});

const posMsg = document.getElementById('posMsg');
document.getElementById('posBtn').addEventListener('click', async () => {
  if(!navigator.geolocation){ posMsg.textContent='Sem geolocalização.'; return; }
  posMsg.textContent='Obtendo GPS...';
  navigator.geolocation.getCurrentPosition(async (pos)=>{
    const lat = pos.coords.latitude, lng = pos.coords.longitude;
    const res = await fetch('api/update_motoboy_position.php', {
      method:'POST',
      headers:{'Content-Type':'application/x-www-form-urlencoded'},
      body:'lat='+encodeURIComponent(lat)+'&lng='+encodeURIComponent(lng)
    });
    const j = await res.json();
    posMsg.textContent = j.ok ? 'Posição atualizada.' : (j.error||'Erro');
  }, (err)=> posMsg.textContent='Erro GPS: '+err.message, {enableHighAccuracy:true, timeout:8000});
});
</script>
<?php render_footer(); ?>
