<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/layout.php';
require_company();

$companyId = (int)$_SESSION['company_id'];
$msg = null; $err = null;

function random_token(): string {
  return sha1(bin2hex(random_bytes(32)) . microtime(true));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pickup_address  = trim((string)($_POST['pickup_address'] ?? ''));
  $dropoff_address = trim((string)($_POST['dropoff_address'] ?? ''));
  $customer_name   = trim((string)($_POST['customer_name'] ?? ''));
  $customer_phone  = trim((string)($_POST['customer_phone'] ?? ''));

  $pickup_lat  = $_POST['pickup_lat'] ?? null;
  $pickup_lng  = $_POST['pickup_lng'] ?? null;
  $dropoff_lat = $_POST['dropoff_lat'] ?? null;
  $dropoff_lng = $_POST['dropoff_lng'] ?? null;

  if ($pickup_address === '' || $dropoff_address === '') {
    $err = "Informe endereço de coleta e entrega.";
  } else {
    $token = random_token();

    $st = $pdo->prepare("
      INSERT INTO deliveries
      (company_id, pickup_address, pickup_lat, pickup_lng, dropoff_address, dropoff_lat, dropoff_lng, customer_name, customer_phone, tracking_token)
      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    $st->execute([
      $companyId,
      $pickup_address,
      ($pickup_lat !== '' ? $pickup_lat : null),
      ($pickup_lng !== '' ? $pickup_lng : null),
      $dropoff_address,
      ($dropoff_lat !== '' ? $dropoff_lat : null),
      ($dropoff_lng !== '' ? $dropoff_lng : null),
      ($customer_name !== '' ? $customer_name : null),
      ($customer_phone !== '' ? $customer_phone : null),
      $token
    ]);

    $id = (int)$pdo->lastInsertId();
    $msg = "Entrega criada! Link de rastreio: track.php?t=$token (ID #$id)";
  }
}

render_header('Empresa - Nova entrega');
?>
<div class="card">
  <h1>Solicitar motoboy</h1>
  <p class="small">
    Para a <b>fila inteligente</b> funcionar por distância, preencha <b>lat/lng de coleta</b>.
    (Depois podemos colocar seleção no mapa.)
  </p>

  <?php if ($msg): ?><div class="notice"><?= h($msg) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="notice"><?= h($err) ?></div><?php endif; ?>

  <form method="post" class="grid">
    <div class="grid grid-2">
      <div>
        <label>Endereço de coleta</label>
        <input name="pickup_address" required placeholder="Rua X, 123">
        <div class="row">
          <div>
            <label>Lat (recomendado)</label>
            <input name="pickup_lat" placeholder="-3.7319">
          </div>
          <div>
            <label>Lng (recomendado)</label>
            <input name="pickup_lng" placeholder="-38.5267">
          </div>
        </div>
      </div>

      <div>
        <label>Endereço de entrega</label>
        <input name="dropoff_address" required placeholder="Av Y, 456">
        <div class="row">
          <div>
            <label>Lat (opcional)</label>
            <input name="dropoff_lat">
          </div>
          <div>
            <label>Lng (opcional)</label>
            <input name="dropoff_lng">
          </div>
        </div>
      </div>
    </div>

    <div class="grid grid-2">
      <div>
        <label>Nome do cliente (opcional)</label>
        <input name="customer_name">
      </div>
      <div>
        <label>Telefone do cliente (opcional)</label>
        <input name="customer_phone">
      </div>
    </div>

    <div style="display:flex; gap:10px; flex-wrap:wrap;">
      <button class="btn btn-primary" type="submit">Criar solicitação</button>
      <a class="btn" href="company_dashboard.php">Voltar</a>
      <a class="btn" href="company_deliveries.php">Ver entregas</a>
    </div>
  </form>
</div>
<?php render_footer(); ?>
