<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/layout.php';
require_company();

$companyId = (int)$_SESSION['company_id'];
$deliveryId = (int)($_GET['id'] ?? 0);

$st = $pdo->prepare("
  SELECT d.*, m.name AS motoboy_name
  FROM deliveries d
  LEFT JOIN motoboys m ON m.id = d.motoboy_id
  WHERE d.id=? AND d.company_id=?
");
$st->execute([$deliveryId, $companyId]);
$d = $st->fetch();
if(!$d){ http_response_code(404); die("Entrega não encontrada."); }

render_header("Entrega #{$deliveryId}");
?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css">
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<div class="card">
  <h1>Entrega #<?= (int)$d['id'] ?></h1>
  <div class="grid grid-2">
    <div>
      <div class="small">Status</div>
      <div class="badge warn" id="st"><?= h($d['status']) ?></div>

      <div style="height:10px"></div>

      <div class="small">Motoboy</div>
      <div class="notice" id="moto"><?= h($d['motoboy_name'] ?? 'Aguardando aceite...') ?></div>

      <div style="height:10px"></div>

      <div class="small">Coleta</div>
      <div class="notice"><?= h($d['pickup_address']) ?></div>

      <div class="small">Entrega</div>
      <div class="notice"><?= h($d['dropoff_address']) ?></div>

      <div style="height:10px"></div>

      <div style="display:flex; gap:10px; flex-wrap:wrap;">
        <a class="btn btn-ghost" target="_blank" href="track.php?t=<?= h($d['tracking_token']) ?>">Abrir link do cliente</a>
        <?php if (!empty($d['proof_photo_path'])): ?>
          <a class="btn btn-ghost" target="_blank" href="<?= h($d['proof_photo_path']) ?>">Ver foto</a>
        <?php endif; ?>
        <?php if ($d['status'] === 'delivered'): ?>
          <a class="btn btn-ok" href="company_rate_delivery.php?id=<?= (int)$d['id'] ?>">Avaliar</a>
        <?php endif; ?>
      </div>
    </div>

    <div>
      <div class="small">Mapa (tempo real)</div>
      <div id="map" style="height:360px; border-radius:14px; border:1px solid rgba(255,255,255,.08);"></div>
      <div class="small" id="loc">Conectando...</div>
    </div>
  </div>
</div>

<script>
let map = L.map('map').setView([-3.7319, -38.5267], 12);
L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {maxZoom:19}).addTo(map);

let marker = L.marker([-3.7319, -38.5267]).addTo(map);
let poly = L.polyline([], {}).addTo(map);
let points = [];

const es = new EventSource('sse_track.php?t=<?= h($d['tracking_token']) ?>');
es.onmessage = (ev) => {
  const j = JSON.parse(ev.data);
  document.getElementById('st').textContent = j.status;
  document.getElementById('moto').textContent = j.motoboy_name || 'Aguardando aceite...';

  if(j.last_lat){
    const lat = parseFloat(j.last_lat), lng = parseFloat(j.last_lng);
    document.getElementById('loc').textContent = `${lat.toFixed(5)}, ${lng.toFixed(5)} • ${j.last_time}`;
    marker.setLatLng([lat,lng]);
    points.push([lat,lng]);
    if(points.length>1) poly.setLatLngs(points);
    map.setView([lat,lng], Math.max(map.getZoom(), 15));
  } else {
    document.getElementById('loc').textContent = 'Sem localização ainda.';
  }
};
</script>

<?php render_footer(); ?>
