<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/layout.php';
require_company();

$companyId = (int)$_SESSION['company_id'];

$st = $pdo->prepare("
  SELECT d.*, m.name AS motoboy_name
  FROM deliveries d
  LEFT JOIN motoboys m ON m.id = d.motoboy_id
  WHERE d.company_id = ?
  ORDER BY d.id DESC
  LIMIT 200
");
$st->execute([$companyId]);
$rows = $st->fetchAll();

render_header('Empresa - Entregas');
?>
<div class="card">
  <h1>Entregas</h1>
  <p class="small">Dica: clique em <b>Ver</b> para acompanhar o mapa em tempo real.</p>

  <table class="table">
    <thead>
      <tr>
        <th>#</th>
        <th>Status</th>
        <th>Motoboy</th>
        <th>Coleta</th>
        <th>Entrega</th>
        <th>Ações</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($rows as $d): ?>
        <tr>
          <td><?= (int)$d['id'] ?></td>
          <td><?= h($d['status']) ?></td>
          <td><?= h($d['motoboy_name'] ?? '-') ?></td>
          <td><?= h($d['pickup_address']) ?></td>
          <td><?= h($d['dropoff_address']) ?></td>
          <td style="white-space:nowrap;">
            <a class="btn btn-primary" href="company_delivery_view.php?id=<?= (int)$d['id'] ?>">Ver</a>
            <a class="btn btn-ghost" href="track.php?t=<?= h($d['tracking_token']) ?>" target="_blank">Cliente</a>
            <?php if (!empty($d['proof_photo_path'])): ?>
              <a class="btn btn-ghost" target="_blank" href="<?= h($d['proof_photo_path']) ?>">Foto</a>
            <?php endif; ?>
            <?php if ($d['status'] === 'delivered'): ?>
              <a class="btn btn-ok" href="company_rate_delivery.php?id=<?= (int)$d['id'] ?>">Avaliar</a>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <div style="margin-top:12px; display:flex; gap:10px;">
    <a class="btn" href="company_dashboard.php">Voltar</a>
    <a class="btn btn-primary" href="company_new_delivery.php">Nova entrega</a>
  </div>
</div>
<?php render_footer(); ?>
