<?php
declare(strict_types=1);
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';
require_motoboy();

header('Content-Type: application/json');

$motoboyId = (int)$_SESSION['motoboy_id'];
$deliveryId = (int)($_POST['delivery_id'] ?? 0);
$status = (string)($_POST['status'] ?? '');

$allowed = ['accepted','picked_up','delivering','delivered','canceled'];
if ($deliveryId <= 0 || !in_array($status, $allowed, true)) {
  echo json_encode(['ok'=>false,'error'=>'Dados inválidos']); exit;
}

$extraSql = "";
if ($status === 'delivered') $extraSql = ", delivered_at = NOW()";

$st = $pdo->prepare("
  UPDATE deliveries
  SET status = ? $extraSql
  WHERE id = ? AND motoboy_id = ?
");
$st->execute([$status, $deliveryId, $motoboyId]);

echo json_encode(['ok'=>true]);
