<?php
declare(strict_types=1);
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';
require_company();

header('Content-Type: application/json');

$companyId = (int)$_SESSION['company_id'];
$deliveryId = (int)($_GET['delivery_id'] ?? 0);

$st = $pdo->prepare("
  SELECT d.status, m.name AS motoboy_name
  FROM deliveries d
  LEFT JOIN motoboys m ON m.id = d.motoboy_id
  WHERE d.id=? AND d.company_id=?
");
$st->execute([$deliveryId, $companyId]);
$row = $st->fetch();

if (!$row) { echo json_encode(['ok'=>false,'error'=>'Não encontrada']); exit; }
echo json_encode(['ok'=>true,'status'=>$row['status'],'motoboy_name'=>$row['motoboy_name']]);
